import { createSoundCategory } from "./create-sound-element.js";
import createCategory from "./create-category.js";
const SOUND_STYLES = [
    "8-bit",
    "Anger",
    "Artificial",
    "Blade",
    "Blaster",
    "Blizz",
    "Buzz",
    "Cartoon",
    "Cinematic",
    "Classic",
    "Corporate",
    "Digital",
    "Diod",
    "Electro Ball",
    "Emerald",
    "Epic",
    "Fire Ball",
    "Flash",
    "Flex",
    "Fluid Mirror",
    "Fusion",
    "Glass",
    "Hologram",
    "Interface",
    "Jet",
    "Light Speed",
    "Magic",
    "Mech",
    "Melodic",
    "Metallic",
    "Morph",
    "Raid",
    "Rewind",
    "Sacred",
    "Shutter",
    "Silicon",
    "Simple",
    "Speed",
    "Swoop",
    "Synthetic",
    "Technology",
    "Torpedo",
    "Transform",
    "UFO",
    "Venom",
    "Vibro",
    "Vortex",
    "Warp",
    "Warp Engine",
    "Windy"
];
export const SOUND_PACK = {
    "Sound pack": {
        packFromDatabase: {
            name: "Sound pack",
            motionBroSfxPack: true,
            markers: {
                "Bounce": "00:00:00:12 - 00:00:01:00",
                "Cubic": "00:00:00:12 - 00:00:01:00",
                "Ease in": "00:00:00:12 - 00:00:01:00",
                "Ease Out": "00:00:00:12 - 00:00:01:00",
                "Easy Ease": "00:00:00:12 - 00:00:01:00",
                "Linear": "00:00:00:12 - 00:00:01:00",
                "Shake": "00:00:00:12 - 00:00:01:00",
                "Swinging": "00:00:00:12 - 00:00:01:00",
                "Wheel Ease in": "00:00:00:12 - 00:00:01:00",
                "Wheel Ease Out": "00:00:00:12 - 00:00:01:00",
                "Wheel Easy Ease": "00:00:00:12 - 00:00:01:00",
                "Zoom Ease in 1": "00:00:00:12 - 00:00:01:00",
                "Zoom Ease in 2": "00:00:00:12 - 00:00:01:00",
                "Zoom Ease Out 1": "00:00:00:12 - 00:00:01:00",
                "Zoom Easy Ease 1": "00:00:00:12 - 00:00:01:00",
                "Zoom Easy Ease 2": "00:00:00:12 - 00:00:01:00",
                "Zoom Easy Ease 3": "00:00:00:12 - 00:00:01:00",
                "Zoom Hit 1": "00:00:00:12 - 00:00:01:00",
                "Zoom Hit 2": "00:00:00:12 - 00:00:01:00",
                "Zoom Linear 1": "00:00:00:12 - 00:00:01:00",
                "Zoom Linear 2": "00:00:00:12 - 00:00:01:00",
                "Zoom Swinging 1": "00:00:00:12 - 00:00:01:00",
                "Zoom Swinging 2": "00:00:00:12 - 00:00:01:00"
            },
            settings: {
                "soundDropdown": true,
                "soundDropdownOptions": [
                    "NONE",
                    "",
                    ...SOUND_STYLES
                ],
                "soundDropdownOptionsDefault": "Anger"
            },
        },
        categories: SOUND_STYLES.map(style => createCategory({
            categoryName: style,
            packFolderName: "Sound pack",
            children: createSoundCategory({ categoryName: style })
        }))
    }
};
